﻿# 工程文件格式

## 概念解释

### 工程

默认是指程序所在目录下的`project.mlp`文件，目前支持这一个指定名称。

这是一个包含了一堆存放描述和指令的文件。

### 路径

这里的路径可以是相对路径也可以是绝对路径。

相对路径目前是指依程序所在路径为参考的，而不是工程所在路径。

### 基本命令原理

#### 命令是如何在程序内部分割的

所有命令以**行**为基础，换行代表一个新的**命令**。

每一行中用空格或者水平制表符分隔开来形成许多**部分**，但是等号会是一个**例外**，无论它两边有多少空格（制表符）都会将两边的部分连成一个整体，仍为一个**部分**。

当然等号也有**例外**，一个每一对双引号中的第二个会结束一个**部分**，所以譬如`"a"=b`的语句中的等号不会连接左侧，此语法不对。（实则懒得合并左侧）

**注意：请不要使用`Annoy+数字`形式的键名，如`Annoy001`，这些都是保留键名！**

**对于某些键的值是多个的，一般会用逗号隔开，请尽量不要在这些值之间插入不必要的空格，避免发生程序对这个值不可识别。**

#### 匿名值与键/值

`value1 key1=value2 #comment`

`value1`代表的是一个**匿名值**，一般是有程序按照既定顺序判定它的意义。

`key1`代表一个**键**，它位于等号左边，用于描述右边的值的意义。

`value2`代表一个**值**，它位于等号右边，被左边的键名赋予意义。

`comment`是一个**注释**，它不会被程序加载，不对程序运行产生影响。

我们称一个类似`value1`或者`key1=value2`的部分为**记录**或**参数**。

#### 块

```
blockHeader {
    key1=value1
    key2=value2
}
```

`blockHeader`代表**块的头部**，它的作用是省略在大括号内的头部定义，所以它等效于：

```
blockHeader key1=value1
blockHeader key2=value2
```

**注意：因为一对双引号两端只能为空格或者等号，所以譬如`"a" {`的块头部的双引号与大括号之间不可缺少空格。**（实则懒得多检测一个字符）

## 工程头部

**第一行必须是`Project.Version = "2.0"`这是工程版本声明。**暂时不支持版本向下兼容，这个也许我会做的。（嗯，也许）

## 基本格式

`页码 (+ 按键) + 一堆值...`

## 参数列表

### 键名可选参数

**键名可选参数**是指键名可以省略的参数，但是它们必须在一行代码中按照**顺序**书写，**通常（目前）不支持重复的可选键名**。

目前支持的键名可选参数有：`Page`和`Key`

完整的一行记录应该是类似这样的代码：`Page="*" Key="A" ...`

因为`Page`和`Key`是键名可选参数，所以：上述代码可以等效于：

`"*" Key="A" ...`

或

`Page="*" "A" ...`

或

`"*" "A" ...`

其中第三种的会按照**默认顺序：`Page, Key`**自动解析为`Page="*" Key="A" ...`

当然当`Page`或`Key`如果没有省略键名，它的位置是可以随意的：

`"A" Page="*" ...`

它会先搜索到`Page`键然后搜索下一个键名可选参数`Key`，而`Key`的键名不存在，所以它会读取第一个匿名值作为`Key`的值。

#### Page

命令格式：`Page=<page number>`

: `page number`是指当这行命令需要记录到的页码。

: 其的值可以为`*`、`@`或者一个`1到32的数字`。

    : `@`是一个特殊的页码，它代表初**始化页**，所有加入到初始化页的命令将会在程序加载工程时被执行，执行完毕后就会被释放。**当这行命令将写入初始化页后面的`Key`应当省略，否则会报错**。

    : `*`代表全部页码即1到32，包含它在的命令将存到全部页面。

: 未来可能会支持范围页面以及混合页面，敬请期待。

#### Key

命令格式：`Key=<key>`

: `key`是指当这行命令将会被哪个按键触发。目前允许同页面中有同样`Key`值的多个命令。未来可能还会支持混合按键值，敬请期待。

: 其的值为Winforms中`Keys`的枚举值的名称或者数值，具体可参阅[Keys Enum (System.Windows.Forms) | Microsoft Docs](https://docs.microsoft.com/zh-cn/dotnet/api/system.windows.forms.keys?view=netcore-3.1#fields)。

### 一般原生参数

#### Audio

命令格式：`Audio=<audio path>`

: `audio path`：音频文件路径。

: 举例：`Audio="sample.wav" #播放音频sample.wav`

#### Background

命令格式：`Background=<type>,<argument>`

: 初始化时的默认值是`Background=SolidColor,0,32,64`。 

: `type`：背景类型，包含`Image`、`SolidColor`。

    : `Image`：表示背景为图片。

    : `SolidColor`：表示背景为纯色。

: `argument`：

    : 当`type`为`Image`时：`<argument>`为`<image path>,<image layout>,<buffer>`。

        : `image path`：图片路径，**暂不支持透明图片**。

        : `image layout`：表示图片的布局方式，包含`None`、`Tile`、`Center`、`Stretch`、`Zoom`。

            : `None`或`0`：保持原大小，与舞台左上角对齐。

            : `Tile`或`1`：平铺。

            : `Center`或`2`：居中。

            : `Stretch`或`3`：拉伸。

            : `Zoom`或`4`：自适应（保持比例放大到最大（保证图片不超出舞台边界））。

            : 其的值为Winforms中`ImageLayout`的枚举值的名称或者数值，具体可参阅[ImageLayout Enum (System.Windows.Forms) | Microsoft Docs](https://docs.microsoft.com/zh-cn/dotnet/api/system.windows.forms.imagelayout?view=netcore-3.1#fields)。

        : `buffer`：是否缓存，可填入一个bool值，即`true`或`false`，如果开启缓存则会在加载时写入内存，如果关闭则会在调用到该命令时才会读取文件。如果图片较大，开启可以减少延迟，但是关闭的话可以优化内存用量。

    : 当`type`为`SolidColor`时：`<argument>`为`<red>,<blue>,<green>`。

        : `red`：RBG值中的红色值，该值应当为是0~255。

        : `blue`：RBG值中的蓝色值，该值应当为是0~255。

        : `green`：RBG值中的绿色值，该值应当为是0~255。

: 举例：`"Background=sample.png,Zoom"` 或 `"Background=sample.png,4"` 把背景图片设置为`sample.png`，并自适应大小。

: `"Background=SolidColor,255,255,255"` 则是设置背景为纯白色。

: 未来可能会支持多个背景重叠（不过这功能应该是通过一个单独的多图层渲染器实现，而不是调用多个参数），敬请期待。

#### ChangePage

命令格式：`ChangePage=<page number>`

: `page number`：目标页码（只允许为1~32）。

: 举例：`ChangePage=12 #设置绑定的跳转页面为第12页`

#### SetStage

命令格式：`SetStage=<column>,<row>`

: `column`：列数，即是舞台的宽度（能竖着放几排视频位置），**该值是必须至少为1的整数**。

: `row`：行数，即是舞台的高度（能横着放几排视频位置），**该值是必须至少为1的整数**。

#### StagePosition

命令格式：`StagePosition=<x>,<y>`

: 该参数仅对`Video`有效，**默认值为`0,0`**。

: **请记得将该参数放在`Video`前，否侧会因为顺序性而失效**。

: 舞台的坐标系是向右为x轴为正，向下为y轴正方向。

: `x`：舞台上的x坐标位置，**这个值从0开始**。

: `y`：舞台上的y坐标位置，**这个值从0开始**。

: 举例：`StageSeat="0,1" #设置video的显示坐标为0,1`

#### Stage_FullScreen

命令格式：`Stage_FullScreen=<value>`

: `value`：可填入一个bool值，即`true`或`false`，`true`表示使舞台全屏化，`false`表示使舞台恢复。

: 举例：`Stage_FullScreen="true" #使舞台全屏化`

#### Video

命令格式：`Video=<video path>`

: `video path`：视频文件路径。

: 举例：`Video="sample.mp4" #播放视频sample.mp4`

### 仅用于初始化参数

#### Alias

命令格式：`Alias=<command>,<alias>`

: 给命令取一个别名。不可以取已有参数的名称，别名不是宏定义，仅可用于替代参数名。

: `command`：原命令名称或者其别名。

: `alias`：期望的别名。

: 举例：`Alias="Audio,a" #设置Audio的别名为a,之后可以用a代替Audio，像这样：a="example.wav"`

## 其他内容

### 字符串

**注意：双引号只允许两种使用形式：`"Key=Value"`（即`"string"`）或`Key="Value"`。**

### 注释

#### 整行注释

`#comment`

第一个字符为井号的行会被注释掉。

#### 尾部注释

`abc #comment`

以井号为开头的部分为注释，**这种注释生效需要保证前面为空格**。

所以上面的内容等效为`abc`。

以下内容不算尾部注释：

`abc#comment`

因为井号前面缺少空格所以它会被完整识别为`abc#comment`。

## 更多的完整例子

1. 例一：
    
    `"@" ChangePage=1`
    
    这个表示在初始化时跳转到页面1。
    
    **注意：由于页码`@`和`*`是符号，为了不被识别为操作符，所以应该用双引号括起来。**

2. 例二：
    
    `"*" 56 Audio="./sample.wav"`
    
    这个表示在所有页面记录：当按下`A`时播放当前目录下的`sample.wav`。
    
    也就是说，当当前页码为1时，按下`A`就播放`sample.wav`。
    
    **注意：`56`并不是A的ASCII值，而是WinForms中`Keys.A`的枚举值。**

3. 例三：
    
    `3 "D1" Video="sample.mp4" Stage="2,1"`
    
    这个表示在页面3记录：当按下数字键1时在第3列第2行播放当前目录下的`sample.mp4`。
    
    **如果有空格为了表示为一个部分要加双引号，没有空格也可以加双引号。**